Rem
Rem $Header: rdbms/demo/rac_wrappers/qryshard.sql /main/1 2010/04/22 23:33:33 swshekha Exp $
Rem
Rem qryshard.sql
Rem
Rem Copyright (c) 2009, 2010, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      qryshard.sql - Display Shard info table 
Rem
Rem    DESCRIPTION
Rem      print info in shard map table for the queue 
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rbhyrava    12/02/09 - Created
Rem

REM ==================================================
REM  Package for querying SHRD$_MAP_TABLE
REM ==================================================
CREATE OR REPLACE PACKAGE shrdinfo AS 
FUNCTION get_PHYSICAL_QT(owner varchar2, qtab varchar2  ) RETURN VARCHAR2;
FUNCTION get_PHYSICAL_QUEUE(owner varchar2, qnm varchar2  ) RETURN VARCHAR2;
procedure print ( p1 varchar2 default '%', p2 varchar2 default '%') ;
v1 wrapperuser.SHRD$_MAP_TABLE%ROWTYPE;
END shrdinfo;
/
SHOW ERRORS

CREATE OR REPLACE PACKAGE BODY shrdinfo AS

FUNCTION get_PHYSICAL_QT(owner varchar2, qtab varchar2  ) RETURN VARCHAR2 IS
current_inst NUMBER := dbms_utility.current_instance;
phy_qtab varchar2(30);
BEGIN
SELECT PHYSICAL_QT into phy_qtab FROM SHRD$_MAP_TABLE
WHERE schema = owner
  and logical_qt = qtab
  and primary_inst = current_inst 
  and ROWNUM < 2;

RETURN phy_qtab;
EXCEPTION
WHEN NO_DATA_FOUND THEN
     return qtab;
END;
--
FUNCTION get_PHYSICAL_QUEUE(owner varchar2, qnm varchar2  ) RETURN VARCHAR2 IS
current_inst NUMBER := dbms_utility.current_instance;
phy_q varchar2(30);
BEGIN
SELECT PHYSICAL_QUEUE into phy_q FROM SHRD$_MAP_TABLE
WHERE schema = owner
  and logical_queue = qnm
  and primary_inst = current_inst
  and ROWNUM < 2;

RETURN phy_q;
EXCEPTION
WHEN NO_DATA_FOUND THEN
     return qnm;
END;

--
PROCEDURE print(p1 varchar2 default '%', p2 varchar2  default '%' ) IS 
hdr number := 0;
cursor c1 ( v1 varchar2, v2 varchar2) is 
 select * from shrd$_map_table 
  WHERE schema like '%' || upper(c1.v1) || '%'  
    AND logical_queue like '%' || upper(c1.v2) || '%' ;
cnt number := 0;
BEGIN 
select count(*) into cnt from shrd$_map_table
WHERE schema like '%' || upper(p1) || '%'
  and logical_queue like '%' ||  upper(p2) || '%' ;
dbms_output.put_line ( 'Count in shrd$_map_table for ' || p1 || ' ' || p2 || ' is:' || cnt) ;
select count(*) into cnt from shrd$_map_table;
dbms_output.put_line ( 'Count in shrd$_map_table:' || cnt) ;

  hdr := 0;
  for a in c1 ( p1, p2) loop 
     IF hdr = 0 THEN
       dbms_output.put_line(rpad('-',80,'-'));
       dbms_output.put_line('--             SHRD$MAP_TABLE') ;
       dbms_output.put_line(rpad('-',80,'-'));
       dbms_output.put_line(
                       rpad('SCHEMA',10,' ') ||
                       rpad('LOGQT ',18,' ') ||
                       rpad('PHYQT',18,' ' )||
                       rpad('LOGQ',18,' ' )||
                       rpad('PHYQ',18,' ')||
                       rpad('PINST',6,' ')||
                       rpad('SINST',6,' ') ||
                       rpad('UNSHRD ',7,' '));
       dbms_output.put_line(rpad('-',80,'-'));
       hdr := 1;
     END IF;
     dbms_output.put_line(
                    rpad(to_char(a.schema),10,' ') ||
                    rpad(to_char(a.logical_qt),18,' ') ||
                    rpad(to_char(a.physical_qt),18,' ') ||
                    rpad(to_char(a.logical_queue),18,' ') ||
                    rpad(to_char(a.physical_queue),18,' ') ||
                    rpad(to_char(a.primary_inst),6,' ') ||
                    rpad(to_char(a.secondary_inst),6,' ') ||
                    rpad(to_char(a.unshrd_in_progress),7,' ') );
   END LOOP;

END;
END shrdinfo;
/
SHOW ERRORS

grant execute on shrdinfo to public; 


